using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Borland.Eco.Handles;
using Borland.Eco.Windows.Forms;
using Borland.Eco.WinForm;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;

namespace ChangeLogging
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.IContainer components;
		private Borland.Eco.Handles.ReferenceHandle rhRoot;
		private Borland.Eco.WinForm.EcoActionExtender EcoGlobalActions;
		private Borland.Eco.WinForm.EcoDragDropExtender EcoModelAwareDragDrop;
		private Borland.Eco.WinForm.EcoAutoFormExtender EcoAutoForms;
		private Borland.Eco.WinForm.EcoListActionExtender EcoListActions;
		private ChangeLoggingEcoSpace ecoSpace;
		private Borland.Eco.Handles.ExpressionHandle expressionHandle1;
		private System.Windows.Forms.ListBox listBox1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox textBox2;
		private System.Windows.Forms.ToolTip toolTip1;
		public ChangeLoggingEcoSpace EcoSpace
		{
			get { 
				if (ecoSpace == null)
				{
					ecoSpace = new ChangeLoggingEcoSpace();
					rhRoot.EcoSpace = ecoSpace;
				}
				return ecoSpace;
			}
		}

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			// The line below will automatically activate the ECO Space.
			// Remove the line if you need to perform any initialization
			// before activating the ECO Space
			EcoSpace.Active = true;
			EcoSpace.m_ChangeTrackingCache.MemberChanged += new ChangeDelegate(OnMemberChanged);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.rhRoot = new Borland.Eco.Handles.ReferenceHandle();
			this.EcoListActions = new Borland.Eco.WinForm.EcoListActionExtender();
			this.button1 = new System.Windows.Forms.Button();
			this.EcoModelAwareDragDrop = new Borland.Eco.WinForm.EcoDragDropExtender();
			this.EcoGlobalActions = new Borland.Eco.WinForm.EcoActionExtender();
			this.EcoAutoForms = new Borland.Eco.WinForm.EcoAutoFormExtender();
			this.expressionHandle1 = new Borland.Eco.Handles.ExpressionHandle();
			this.listBox1 = new System.Windows.Forms.ListBox();
			this.label1 = new System.Windows.Forms.Label();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.textBox2 = new System.Windows.Forms.TextBox();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.SuspendLayout();
			// 
			// rhRoot
			// 
			this.rhRoot.EcoSpaceType = typeof(ChangeLogging.ChangeLoggingEcoSpace);
			// 
			// button1
			// 
			this.EcoListActions.SetActionExpression(this.button1, "");
			this.button1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.button1.Location = new System.Drawing.Point(8, 240);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(112, 23);
			this.button1.TabIndex = 2;
			this.button1.Text = "New thing";
			this.toolTip1.SetToolTip(this.button1, "Create a new instance of Thing");
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// EcoGlobalActions
			// 
			this.EcoGlobalActions.CaptionToggleActive = "Deactivate";
			this.EcoGlobalActions.RootHandle = this.rhRoot;
			// 
			// expressionHandle1
			// 
			this.expressionHandle1.Expression = "Thing.allInstances";
			this.expressionHandle1.RootHandle = this.rhRoot;
			// 
			// listBox1
			// 
			this.listBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left)));
			this.listBox1.DataSource = this.expressionHandle1;
			this.listBox1.DisplayMember = "Name";
			this.listBox1.Location = new System.Drawing.Point(8, 24);
			this.listBox1.Name = "listBox1";
			this.listBox1.Size = new System.Drawing.Size(112, 173);
			this.listBox1.TabIndex = 0;
			this.toolTip1.SetToolTip(this.listBox1, "List of all available instances of Thing");
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(100, 16);
			this.label1.TabIndex = 1;
			this.label1.Tag = "";
			this.label1.Text = "Things:";
			// 
			// textBox1
			// 
			this.textBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.textBox1.DataBindings.Add(new System.Windows.Forms.Binding("Text", this.expressionHandle1, "Name"));
			this.textBox1.Location = new System.Drawing.Point(8, 208);
			this.textBox1.Name = "textBox1";
			this.textBox1.Size = new System.Drawing.Size(112, 20);
			this.textBox1.TabIndex = 3;
			this.textBox1.Text = "";
			this.toolTip1.SetToolTip(this.textBox1, "Change names of the currently selected Thing");
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(152, 8);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(100, 16);
			this.label2.TabIndex = 5;
			this.label2.Text = "Change Log:";
			// 
			// textBox2
			// 
			this.textBox2.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.textBox2.Location = new System.Drawing.Point(152, 24);
			this.textBox2.Multiline = true;
			this.textBox2.Name = "textBox2";
			this.textBox2.ReadOnly = true;
			this.textBox2.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.textBox2.Size = new System.Drawing.Size(152, 248);
			this.textBox2.TabIndex = 6;
			this.textBox2.Text = "";
			this.toolTip1.SetToolTip(this.textBox2, "List of changes");
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(312, 278);
			this.Controls.Add(this.textBox2);
			this.Controls.Add(this.textBox1);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.listBox1);
			this.Name = "WinForm";
			this.Text = "ChangeLogging demo";
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			WinFormDequeuer.Active = true;
			Application.Run(new WinForm());
		}
		
		private void button1_Click(object sender, System.EventArgs e)
		{
			new Thing(ecoSpace).Name = "<New thing>";
		}

		private void OnMemberChanged(string message)
		{
			textBox2.AppendText(message + "\r\n");
		}
	}
}
